package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.TablonesDao;
import com.ejie.ab04b.model.Tablones;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TablonesServiceImpl generated by UDA, 25-abr-2016 15:47:19.
 * 
 * @author UDA
 */

@Service(value = "tablonesService")
public class TablonesServiceImpl implements TablonesService {

	@Autowired()
	private TablonesDao tablonesDao;

	/**
	 * Inserts a single row in the Tablones table.
	 * 
	 *  tablones
	 *            Tablones
	 *  Tablones
	 *
	 * @param tablones the tablones
	 * @return the tablones
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tablones add(Tablones tablones) {
		return this.tablonesDao.add(tablones);
	}

	/**
	 * Updates a single row in the Tablones table.
	 * 
	 *  tablones
	 *            Tablones
	 *  Tablones
	 *
	 * @param tablones the tablones
	 * @return the tablones
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tablones update(Tablones tablones) {
		return this.tablonesDao.update(tablones);
	}

	/**
	 * Finds a single row in the Tablones table.
	 * 
	 *  tablones
	 *            Tablones
	 *  Tablones
	 *
	 * @param tablones the tablones
	 * @return the tablones
	 */
	public Tablones find(Tablones tablones) {
		return (Tablones) this.tablonesDao.find(tablones);
	}

	/**
	 * Deletes a single row in the Tablones table.
	 * 
	 *  tablones
	 *            Tablones
	 *
	 * @param tablones the tablones
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Tablones tablones) {
		this.tablonesDao.remove(tablones);
	}

	/**
	 * Finds a list of rows in the Tablones table.
	 * 
	 *  tablones
	 *            Tablones
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Tablones>
	 *
	 * @param tablones the tablones
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<Tablones> findAll(Tablones tablones,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Tablones>) this.tablonesDao.findAll(tablones,
				jqGridRequestDto);
	}

	/**
	 * Finds a list of rows in the Tablones table.
	 * 
	 *  tablones
	 *            Tablones
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Tablones>
	 *
	 * @param tablones the tablones
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<Tablones> vistafindAll(Tablones tablones,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Tablones>) this.tablonesDao.vistafindAll(tablones,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Tablones table using like.
	 * 
	 *  tablones
	 *            Tablones
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Tablones>
	 *
	 * @param tablones the tablones
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<Tablones> findAllLike(Tablones tablones,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Tablones>) this.tablonesDao.findAllLike(tablones,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the Tablones table.
	 * 
	 *  filterTablones
	 *            Tablones
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Tablones>
	 *
	 * @param filterTablones the filter tablones
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<Tablones> filter(Tablones filterTablones,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Tablones> listaTablones = this.tablonesDao.findAllLike(
				filterTablones, jqGridRequestDto, false);
		Long recordNum = this.tablonesDao
				.findAllLikeCount(filterTablones != null ? filterTablones
						: new Tablones(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Tablones>> reorderSelection = this.tablonesDao
					.reorderSelection(filterTablones, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Tablones>(jqGridRequestDto, recordNum,
					listaTablones, reorderSelection);
		}
		return new JQGridResponseDto<Tablones>(jqGridRequestDto, recordNum,
				listaTablones);
	}

	/**
	 * Reorder the selection made in Tablones table.
	 * 
	 *  filterTablones
	 *            Tablones
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterTablones the filter tablones
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(Tablones filterTablones,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.tablonesDao.reorderSelection(filterTablones,
				jqGridRequestDto, startsWith);
	}

}
